/* ********************************************************************
  9000 ƷתרҵʽSQL

  By Sam on 2009-01-07
**********************************************************************/


/* ҳ */
SELECT DISTINCT item_clsno, item_clsname
  into #Category
  FROM bi_t_item_cls
  WHERE item_flag = '0'

/* ѯƷϢ */
select Barcode = g.barcode,
       GoodsNO = g.item_no,
       GoodsName = g.item_name,
       CategoryName = c.item_clsname,
       Spec = item_size,
       Unit = g.unit_no,
       BuyPrice = price,
       SalePrice = sale_price,
       VipPrice = g.vip_price,
       BuyTaxRate = 0,
       SaleTaxRate = 0,
       CaseUnits = 1,
       Home = product_area,
       VendorNO = g.sup_no,
       VendorName = convert(varchar(60), ''),
       BrandNO = g.item_brand,
       Brand = convert(varchar(40), ''),
       StockQty = convert(numeric(12,3), null),
       Memo1 = g.item_other1,
       Memo2 = g.item_other2
  into #a
  from bi_t_item_info g, #Category c
  where g.item_clsno = c.item_clsno

/* ¹Ӧ */
update #a
  set VendorName = case when VendorNO = '0' then '' else v.sup_name end
  from bi_t_supcust_info v
  where VendorNO = v.supcust_no

/* Ʒ */
update #a
set Brand = v.item_clsname
  from bi_t_item_cls v
  where BrandNO = v.item_clsno
    and v.item_flag = '1' and v.display_flag = '1' and v.item_clsno <> '00'

/* вֿĿ */
select item_no, stock_qty = sum(isnull(c.sale_qnty,0)) into #b
  from pos_v_sale_qnty c
  group by item_no

/* ʱĿ */
update #a
  set StockQty = b.stock_qty
  from #b b
  where GoodsNO = b.item_no

/* ΪƷ룬滹и룬Ҫһͬʾ */
/* ע⣬ƷҪΪ0 */
select
     = CategoryName,
    Ʒ = GoodsName,
     = isnull(Spec, ''),
    λ = isnull(Unit, ''),
     = Barcode,
     = BuyPrice,
    ۼ = SalePrice,
    Աۼ = VipPrice,
     = StockQty,
    Ӧ = isnull(VendorName, ''),
    ˰ = BuyTaxRate,
    ˰ = SaleTaxRate,
    װλ = CaseUnits,
     = isnull(Home, ''),
    Ʒ = isnull(Brand, ''),
    ע1 = Memo1,
    ע2 = Memo2,
    Ʒ = GoodsNO into #c
  from #a
union
select
     = CategoryName,
    Ʒ = GoodsName,
     = isnull(Spec, ''),
    λ = isnull(Unit, ''),
     = b.barcode,
     = BuyPrice,
    ۼ = SalePrice,
    Աۼ = VipPrice,
     = 0,
    Ӧ = isnull(VendorName, ''),
    ˰ = BuyTaxRate,
    ˰ = SaleTaxRate,
    װλ = CaseUnits,
     = isnull(Home, ''),
    Ʒ = isnull(Brand, ''),
    ע1 = Memo1,
    ע2 = Memo2,
    Ʒ = GoodsNO
  from #a a, bi_t_item_barcode b
  where GoodsNO = b.item_no

select * from #c order by Ʒ, abs() desc

drop table #a, #b, #Category, #c


